/*
 * Decompiled with CFR 0.152.
 */
package dev.toma.gunsrpg.common.init;

import dev.toma.gunsrpg.common.entity.projectile.AbstractProjectile;
import dev.toma.gunsrpg.common.init.WeaponDamageSource;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;

public final class ModDamageSources {
    public static final DamageSource POISON_DAMAGE = new SimpleDamageSource("poison").func_76348_h();
    public static final DamageSource INFECTION_DAMAGE = new SimpleDamageSource("infection").func_76348_h();
    public static final DamageSource BLEED_DAMAGE = new SimpleDamageSource("bleeding").func_76348_h();
    public static final DamageSource FRACTURE_DAMAGE = new SimpleDamageSource("fracture").func_76348_h();

    public static DamageSource gunAttack(Entity owner, AbstractProjectile projectile, ItemStack gun) {
        return new WeaponDamageSource(owner, projectile, gun);
    }

    public static DamageSource spikes(Entity owner) {
        return new SpikeDamageSource(owner);
    }

    private ModDamageSources() {
    }

    private static class SpikeDamageSource
    extends EntityDamageSource {
        public SpikeDamageSource(@Nullable Entity owner) {
            super("spikes", owner);
            this.func_76348_h();
        }

        public ITextComponent func_151519_b(LivingEntity victim) {
            String key = "death.attack." + this.field_76373_n;
            if (this.field_76386_o != null) {
                key = key + ".owner";
                return new TranslationTextComponent(key, new Object[]{victim.func_145748_c_(), this.field_76386_o.func_145748_c_()});
            }
            return new TranslationTextComponent(key, new Object[]{victim.func_145748_c_()});
        }
    }

    private static class SimpleDamageSource
    extends DamageSource {
        private SimpleDamageSource(String messageId) {
            super(messageId);
        }

        public ITextComponent func_151519_b(LivingEntity victim) {
            String messageId = this.func_76355_l();
            String localizationText = "death.attack." + messageId;
            return new TranslationTextComponent(localizationText, new Object[]{victim.func_145748_c_()});
        }
    }
}

